package jamezo97.clonecraft.gui;

import org.lwjgl.opengl.GL11;

import jamezo97.clonecraft.CloneCraftUtils;
import jamezo97.clonecraft.block.TileEntityDNASequencer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiDNASequencer extends GuiContainer{

	TileEntityDNASequencer te;
	
	public GuiDNASequencer(InventoryPlayer inventory, TileEntityDNASequencer te) {
		super(new ContainerDNASequencer(inventory, te));
		this.xSize = 176;
		this.ySize = 210;
		this.te = te;
	}

	ResourceLocation bgImage = new ResourceLocation("CloneCraft:textures/gui/dnaSequencer.png");
	
	
	
	@Override
	protected void drawGuiContainerForegroundLayer(int par1, int par2) {
		
	}



	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
		
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(bgImage);
        int minX = (this.width - this.xSize) / 2;
        int minY = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(minX, minY, 0, 0, this.xSize, this.ySize);
        int i1;
		if (this.te.isBurning())
        {
            i1 = this.te.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(minX + 9, minY + 79 + 12 - i1, 177, 13 - i1, 14, i1 + 2);
        }

		if(this.te.sequenceTime > 0){
			i1 = this.te.getSequenceProgressScaled(160);
			this.drawTexturedModalRect(minX + 8, minY + 116, 0, 210, i1, 6);
			
			int startX = minX + 44;
			int startY = minY + 9;
			
			for(int a = 0; a < this.te.re_arranged.length; a++){
				int type = this.te.re_arranged[a];
				if(type > 0){
					//gyellow f2f73f
					//cblue 3f37ba
					//agreen 56c652
					//tred ea1c29
					int colour = 0x00000000;
					switch(type){
					case 1: colour = 0xfff2f73f; break;
					case 2: colour = 0xff3f37ba; break;
					case 3: colour = 0xff56c652; break;
					case 4: colour = 0xffea1c29; break;
					}
					this.drawRect(startX + 8*a, startY + 4 + (type-1) * 24, startX + 8*(a+1), startY + 24 + (type-1) * 24, colour);
				}
			}
			
		}
		
		CloneCraftUtils.renderSlotResourceOverlays(this);
	}
	
	

	
//	Spacing = 4, x = 20

//	Spacing = 6, x = 17.5

//	Spacing = 8, x = 30
	
}